package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.docdb.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class PendingMaintenanceAction(
    action: Option[String] = None,
    autoAppliedAfterDate: Option[TStamp] = None,
    forcedApplyDate: Option[TStamp] = None,
    optInStatus: Option[String] = None,
    currentApplyDate: Option[TStamp] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction = {
    import PendingMaintenanceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction
      .builder()
      .optionallyWith(action.map(value => value: java.lang.String))(_.action)
      .optionallyWith(
        autoAppliedAfterDate.map(value => TStamp.unwrap(value): Instant)
      )(_.autoAppliedAfterDate)
      .optionallyWith(
        forcedApplyDate.map(value => TStamp.unwrap(value): Instant)
      )(_.forcedApplyDate)
      .optionallyWith(optInStatus.map(value => value: java.lang.String))(
        _.optInStatus
      )
      .optionallyWith(
        currentApplyDate.map(value => TStamp.unwrap(value): Instant)
      )(_.currentApplyDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.PendingMaintenanceAction.ReadOnly =
    zio.aws.docdb.model.PendingMaintenanceAction.wrap(buildAwsValue())
}
object PendingMaintenanceAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.PendingMaintenanceAction =
      zio.aws.docdb.model.PendingMaintenanceAction(
        action.map(value => value),
        autoAppliedAfterDate.map(value => value),
        forcedApplyDate.map(value => value),
        optInStatus.map(value => value),
        currentApplyDate.map(value => value),
        description.map(value => value)
      )
    def action: Option[String]
    def autoAppliedAfterDate: Option[TStamp]
    def forcedApplyDate: Option[TStamp]
    def optInStatus: Option[String]
    def currentApplyDate: Option[TStamp]
    def description: Option[String]
    def getAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("action", action)
    def getAutoAppliedAfterDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("autoAppliedAfterDate", autoAppliedAfterDate)
    def getForcedApplyDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("forcedApplyDate", forcedApplyDate)
    def getOptInStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
    def getCurrentApplyDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("currentApplyDate", currentApplyDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction
  ) extends zio.aws.docdb.model.PendingMaintenanceAction.ReadOnly {
    override val action: Option[String] =
      scala.Option(impl.action()).map(value => value: String)
    override val autoAppliedAfterDate: Option[TStamp] = scala
      .Option(impl.autoAppliedAfterDate())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val forcedApplyDate: Option[TStamp] = scala
      .Option(impl.forcedApplyDate())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val optInStatus: Option[String] =
      scala.Option(impl.optInStatus()).map(value => value: String)
    override val currentApplyDate: Option[TStamp] = scala
      .Option(impl.currentApplyDate())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.PendingMaintenanceAction
  ): zio.aws.docdb.model.PendingMaintenanceAction.ReadOnly = new Wrapper(impl)
}
