package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{BooleanOptional, IntegerOptional}
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterRequest(
    dbClusterIdentifier: String,
    newDBClusterIdentifier: Option[String] = None,
    applyImmediately: Option[Boolean] = None,
    backupRetentionPeriod: Option[IntegerOptional] = None,
    dbClusterParameterGroupName: Option[String] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    port: Option[IntegerOptional] = None,
    masterUserPassword: Option[String] = None,
    preferredBackupWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    cloudwatchLogsExportConfiguration: Option[
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration
    ] = None,
    engineVersion: Option[String] = None,
    deletionProtection: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest = {
    import ModifyDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        newDBClusterIdentifier.map(value => value: java.lang.String)
      )(_.newDBClusterIdentifier)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue())
      )(_.cloudwatchLogsExportConfiguration)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbClusterRequest.ReadOnly =
    zio.aws.docdb.model.ModifyDbClusterRequest.wrap(buildAwsValue())
}
object ModifyDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbClusterRequest =
      zio.aws.docdb.model.ModifyDbClusterRequest(
        dbClusterIdentifier,
        newDBClusterIdentifier.map(value => value),
        applyImmediately.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        port.map(value => value),
        masterUserPassword.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        cloudwatchLogsExportConfiguration.map(value => value.asEditable),
        engineVersion.map(value => value),
        deletionProtection.map(value => value)
      )
    def dbClusterIdentifier: String
    def newDBClusterIdentifier: Option[String]
    def applyImmediately: Option[Boolean]
    def backupRetentionPeriod: Option[IntegerOptional]
    def dbClusterParameterGroupName: Option[String]
    def vpcSecurityGroupIds: Option[List[String]]
    def port: Option[IntegerOptional]
    def masterUserPassword: Option[String]
    def preferredBackupWindow: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def cloudwatchLogsExportConfiguration
        : Option[zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly]
    def engineVersion: Option[String]
    def deletionProtection: Option[BooleanOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getNewDBClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBClusterIdentifier", newDBClusterIdentifier)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getCloudwatchLogsExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudwatchLogsExportConfiguration",
      cloudwatchLogsExportConfiguration
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
  ) extends zio.aws.docdb.model.ModifyDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val newDBClusterIdentifier: Option[String] =
      scala.Option(impl.newDBClusterIdentifier()).map(value => value: String)
    override val applyImmediately: Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val backupRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.docdb.model.primitives.IntegerOptional(value))
    override val dbClusterParameterGroupName: Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.docdb.model.primitives.IntegerOptional(value))
    override val masterUserPassword: Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val preferredBackupWindow: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val cloudwatchLogsExportConfiguration: Option[
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = scala
      .Option(impl.cloudwatchLogsExportConfiguration())
      .map(value =>
        zio.aws.docdb.model.CloudwatchLogsExportConfiguration.wrap(value)
      )
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val deletionProtection: Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.docdb.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
  ): zio.aws.docdb.model.ModifyDbClusterRequest.ReadOnly = new Wrapper(impl)
}
