package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceName: String,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.docdb.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ListTagsForResourceRequest =
      zio.aws.docdb.model.ListTagsForResourceRequest(
        resourceName,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceName: String
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest
  ) extends zio.aws.docdb.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest
  ): zio.aws.docdb.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
