package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.docdb.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class Event(
    sourceIdentifier: Option[String] = None,
    sourceType: Option[zio.aws.docdb.model.SourceType] = None,
    message: Option[String] = None,
    eventCategories: Option[Iterable[String]] = None,
    date: Option[TStamp] = None,
    sourceArn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Event
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.Event.ReadOnly =
    zio.aws.docdb.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.Event = zio.aws.docdb.model.Event(
      sourceIdentifier.map(value => value),
      sourceType.map(value => value),
      message.map(value => value),
      eventCategories.map(value => value),
      date.map(value => value),
      sourceArn.map(value => value)
    )
    def sourceIdentifier: Option[String]
    def sourceType: Option[zio.aws.docdb.model.SourceType]
    def message: Option[String]
    def eventCategories: Option[List[String]]
    def date: Option[TStamp]
    def sourceArn: Option[String]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType: ZIO[Any, AwsError, zio.aws.docdb.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
    def getSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.Event
  ) extends zio.aws.docdb.model.Event.ReadOnly {
    override val sourceIdentifier: Option[String] =
      scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override val sourceType: Option[zio.aws.docdb.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.docdb.model.SourceType.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val date: Option[TStamp] = scala
      .Option(impl.date())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val sourceArn: Option[String] =
      scala.Option(impl.sourceArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.Event
  ): zio.aws.docdb.model.Event.ReadOnly = new Wrapper(impl)
}
