package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeDbInstancesRequest(
    dbInstanceIdentifier: Option[String] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest = {
    import DescribeDbInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeDbInstancesRequest.ReadOnly =
    zio.aws.docdb.model.DescribeDbInstancesRequest.wrap(buildAwsValue())
}
object DescribeDbInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbInstancesRequest =
      zio.aws.docdb.model.DescribeDbInstancesRequest(
        dbInstanceIdentifier.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def dbInstanceIdentifier: Option[String]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest
  ) extends zio.aws.docdb.model.DescribeDbInstancesRequest.ReadOnly {
    override val dbInstanceIdentifier: Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.docdb.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest
  ): zio.aws.docdb.model.DescribeDbInstancesRequest.ReadOnly = new Wrapper(impl)
}
