package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBSubnetGroup(
    dbSubnetGroupName: Option[String] = None,
    dbSubnetGroupDescription: Option[String] = None,
    vpcId: Option[String] = None,
    subnetGroupStatus: Option[String] = None,
    subnets: Option[Iterable[zio.aws.docdb.model.Subnet]] = None,
    dbSubnetGroupArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBSubnetGroup = {
    import DBSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBSubnetGroup
      .builder()
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        dbSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.dbSubnetGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(dbSubnetGroupArn.map(value => value: java.lang.String))(
        _.dbSubnetGroupArn
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBSubnetGroup.ReadOnly =
    zio.aws.docdb.model.DBSubnetGroup.wrap(buildAwsValue())
}
object DBSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBSubnetGroup =
      zio.aws.docdb.model.DBSubnetGroup(
        dbSubnetGroupName.map(value => value),
        dbSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSubnetGroupArn.map(value => value)
      )
    def dbSubnetGroupName: Option[String]
    def dbSubnetGroupDescription: Option[String]
    def vpcId: Option[String]
    def subnetGroupStatus: Option[String]
    def subnets: Option[List[zio.aws.docdb.model.Subnet.ReadOnly]]
    def dbSubnetGroupArn: Option[String]
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescription)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getDbSubnetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupArn", dbSubnetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBSubnetGroup
  ) extends zio.aws.docdb.model.DBSubnetGroup.ReadOnly {
    override val dbSubnetGroupName: Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val dbSubnetGroupDescription: Option[String] =
      scala.Option(impl.dbSubnetGroupDescription()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val subnetGroupStatus: Option[String] =
      scala.Option(impl.subnetGroupStatus()).map(value => value: String)
    override val subnets: Option[List[zio.aws.docdb.model.Subnet.ReadOnly]] =
      scala
        .Option(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Subnet.wrap(item)
          }.toList
        )
    override val dbSubnetGroupArn: Option[String] =
      scala.Option(impl.dbSubnetGroupArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBSubnetGroup
  ): zio.aws.docdb.model.DBSubnetGroup.ReadOnly = new Wrapper(impl)
}
