package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{TStamp, IntegerOptional}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DBCluster(
    availabilityZones: Option[Iterable[String]] = None,
    backupRetentionPeriod: Option[IntegerOptional] = None,
    dbClusterIdentifier: Option[String] = None,
    dbClusterParameterGroup: Option[String] = None,
    dbSubnetGroup: Option[String] = None,
    status: Option[String] = None,
    percentProgress: Option[String] = None,
    earliestRestorableTime: Option[TStamp] = None,
    endpoint: Option[String] = None,
    readerEndpoint: Option[String] = None,
    multiAZ: Option[Boolean] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    latestRestorableTime: Option[TStamp] = None,
    port: Option[IntegerOptional] = None,
    masterUsername: Option[String] = None,
    preferredBackupWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    replicationSourceIdentifier: Option[String] = None,
    readReplicaIdentifiers: Option[Iterable[String]] = None,
    dbClusterMembers: Option[Iterable[zio.aws.docdb.model.DBClusterMember]] =
      None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.docdb.model.VpcSecurityGroupMembership]
    ] = None,
    hostedZoneId: Option[String] = None,
    storageEncrypted: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    dbClusterResourceId: Option[String] = None,
    dbClusterArn: Option[String] = None,
    associatedRoles: Option[Iterable[zio.aws.docdb.model.DBClusterRole]] = None,
    clusterCreateTime: Option[TStamp] = None,
    enabledCloudwatchLogsExports: Option[Iterable[String]] = None,
    deletionProtection: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBCluster = {
    import DBCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBCluster
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterParameterGroup.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroup)
      .optionallyWith(dbSubnetGroup.map(value => value: java.lang.String))(
        _.dbSubnetGroup
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(percentProgress.map(value => value: java.lang.String))(
        _.percentProgress
      )
      .optionallyWith(
        earliestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.earliestRestorableTime)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(readerEndpoint.map(value => value: java.lang.String))(
        _.readerEndpoint
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        replicationSourceIdentifier.map(value => value: java.lang.String)
      )(_.replicationSourceIdentifier)
      .optionallyWith(
        readReplicaIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaIdentifiers)
      .optionallyWith(
        dbClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterMembers)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        dbClusterResourceId.map(value => value: java.lang.String)
      )(_.dbClusterResourceId)
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBCluster.ReadOnly =
    zio.aws.docdb.model.DBCluster.wrap(buildAwsValue())
}
object DBCluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.DBCluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBCluster =
      zio.aws.docdb.model.DBCluster(
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbClusterParameterGroup.map(value => value),
        dbSubnetGroup.map(value => value),
        status.map(value => value),
        percentProgress.map(value => value),
        earliestRestorableTime.map(value => value),
        endpoint.map(value => value),
        readerEndpoint.map(value => value),
        multiAZ.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        latestRestorableTime.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        replicationSourceIdentifier.map(value => value),
        readReplicaIdentifiers.map(value => value),
        dbClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostedZoneId.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterResourceId.map(value => value),
        dbClusterArn.map(value => value),
        associatedRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterCreateTime.map(value => value),
        enabledCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value)
      )
    def availabilityZones: Option[List[String]]
    def backupRetentionPeriod: Option[IntegerOptional]
    def dbClusterIdentifier: Option[String]
    def dbClusterParameterGroup: Option[String]
    def dbSubnetGroup: Option[String]
    def status: Option[String]
    def percentProgress: Option[String]
    def earliestRestorableTime: Option[TStamp]
    def endpoint: Option[String]
    def readerEndpoint: Option[String]
    def multiAZ: Option[Boolean]
    def engine: Option[String]
    def engineVersion: Option[String]
    def latestRestorableTime: Option[TStamp]
    def port: Option[IntegerOptional]
    def masterUsername: Option[String]
    def preferredBackupWindow: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def replicationSourceIdentifier: Option[String]
    def readReplicaIdentifiers: Option[List[String]]
    def dbClusterMembers
        : Option[List[zio.aws.docdb.model.DBClusterMember.ReadOnly]]
    def vpcSecurityGroups
        : Option[List[zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly]]
    def hostedZoneId: Option[String]
    def storageEncrypted: Option[Boolean]
    def kmsKeyId: Option[String]
    def dbClusterResourceId: Option[String]
    def dbClusterArn: Option[String]
    def associatedRoles
        : Option[List[zio.aws.docdb.model.DBClusterRole.ReadOnly]]
    def clusterCreateTime: Option[TStamp]
    def enabledCloudwatchLogsExports: Option[List[String]]
    def deletionProtection: Option[Boolean]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterParameterGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroup)
    def getDbSubnetGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPercentProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getEarliestRestorableTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("earliestRestorableTime", earliestRestorableTime)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getReaderEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("readerEndpoint", readerEndpoint)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReplicationSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSourceIdentifier",
        replicationSourceIdentifier
      )
    def getReadReplicaIdentifiers: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("readReplicaIdentifiers", readReplicaIdentifiers)
    def getDbClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBClusterMember.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembers)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceId)
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getAssociatedRoles
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.DBClusterRole.ReadOnly]] =
      AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBCluster
  ) extends zio.aws.docdb.model.DBCluster.ReadOnly {
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val backupRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.docdb.model.primitives.IntegerOptional(value))
    override val dbClusterIdentifier: Option[String] =
      scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override val dbClusterParameterGroup: Option[String] =
      scala.Option(impl.dbClusterParameterGroup()).map(value => value: String)
    override val dbSubnetGroup: Option[String] =
      scala.Option(impl.dbSubnetGroup()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val percentProgress: Option[String] =
      scala.Option(impl.percentProgress()).map(value => value: String)
    override val earliestRestorableTime: Option[TStamp] = scala
      .Option(impl.earliestRestorableTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val endpoint: Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val readerEndpoint: Option[String] =
      scala.Option(impl.readerEndpoint()).map(value => value: String)
    override val multiAZ: Option[Boolean] =
      scala.Option(impl.multiAZ()).map(value => value: Boolean)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val latestRestorableTime: Option[TStamp] = scala
      .Option(impl.latestRestorableTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.docdb.model.primitives.IntegerOptional(value))
    override val masterUsername: Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val preferredBackupWindow: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val replicationSourceIdentifier: Option[String] = scala
      .Option(impl.replicationSourceIdentifier())
      .map(value => value: String)
    override val readReplicaIdentifiers: Option[List[String]] = scala
      .Option(impl.readReplicaIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterMembers
        : Option[List[zio.aws.docdb.model.DBClusterMember.ReadOnly]] = scala
      .Option(impl.dbClusterMembers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.DBClusterMember.wrap(item)
        }.toList
      )
    override val vpcSecurityGroups: Option[
      List[zio.aws.docdb.model.VpcSecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val hostedZoneId: Option[String] =
      scala.Option(impl.hostedZoneId()).map(value => value: String)
    override val storageEncrypted: Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val dbClusterResourceId: Option[String] =
      scala.Option(impl.dbClusterResourceId()).map(value => value: String)
    override val dbClusterArn: Option[String] =
      scala.Option(impl.dbClusterArn()).map(value => value: String)
    override val associatedRoles
        : Option[List[zio.aws.docdb.model.DBClusterRole.ReadOnly]] = scala
      .Option(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.DBClusterRole.wrap(item)
        }.toList
      )
    override val clusterCreateTime: Option[TStamp] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val enabledCloudwatchLogsExports: Option[List[String]] = scala
      .Option(impl.enabledCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val deletionProtection: Option[Boolean] =
      scala.Option(impl.deletionProtection()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBCluster
  ): zio.aws.docdb.model.DBCluster.ReadOnly = new Wrapper(impl)
}
