package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailabilityZone(name: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.AvailabilityZone
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.AvailabilityZone.ReadOnly =
    zio.aws.docdb.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.AvailabilityZone =
      zio.aws.docdb.model.AvailabilityZone(name.map(value => value))
    def name: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.AvailabilityZone
  ) extends zio.aws.docdb.model.AvailabilityZone.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.AvailabilityZone
  ): zio.aws.docdb.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
