package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  VirtualInterfaceName,
  EnableSiteLink,
  MTU,
  VirtualInterfaceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateVirtualInterfaceAttributesRequest(
    virtualInterfaceId: VirtualInterfaceId,
    mtu: Optional[MTU] = Optional.Absent,
    enableSiteLink: Optional[EnableSiteLink] = Optional.Absent,
    virtualInterfaceName: Optional[VirtualInterfaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest = {
    import UpdateVirtualInterfaceAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .optionallyWith(mtu.map(value => MTU.unwrap(value): Integer))(_.mtu)
      .optionallyWith(
        enableSiteLink.map(value =>
          EnableSiteLink.unwrap(value): java.lang.Boolean
        )
      )(_.enableSiteLink)
      .optionallyWith(
        virtualInterfaceName.map(value =>
          VirtualInterfaceName.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceName)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest.ReadOnly =
    zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest
      .wrap(buildAwsValue())
}
object UpdateVirtualInterfaceAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest =
      zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest(
        virtualInterfaceId,
        mtu.map(value => value),
        enableSiteLink.map(value => value),
        virtualInterfaceName.map(value => value)
      )
    def virtualInterfaceId: VirtualInterfaceId
    def mtu: Optional[MTU]
    def enableSiteLink: Optional[EnableSiteLink]
    def virtualInterfaceName: Optional[VirtualInterfaceName]
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
    def getMtu: ZIO[Any, AwsError, MTU] = AwsError.unwrapOptionField("mtu", mtu)
    def getEnableSiteLink: ZIO[Any, AwsError, EnableSiteLink] =
      AwsError.unwrapOptionField("enableSiteLink", enableSiteLink)
    def getVirtualInterfaceName: ZIO[Any, AwsError, VirtualInterfaceName] =
      AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest
  ) extends zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
    override val mtu: Optional[MTU] = zio.aws.core.internal
      .optionalFromNullable(impl.mtu())
      .map(value => zio.aws.directconnect.model.primitives.MTU(value))
    override val enableSiteLink: Optional[EnableSiteLink] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSiteLink())
        .map(value =>
          zio.aws.directconnect.model.primitives.EnableSiteLink(value)
        )
    override val virtualInterfaceName: Optional[VirtualInterfaceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceName())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest
  ): zio.aws.directconnect.model.UpdateVirtualInterfaceAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
