package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.DirectConnectGatewayAssociationId
import scala.jdk.CollectionConverters._
final case class UpdateDirectConnectGatewayAssociationRequest(
    associationId: Optional[DirectConnectGatewayAssociationId] =
      Optional.Absent,
    addAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent,
    removeAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest = {
    import UpdateDirectConnectGatewayAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
      .builder()
      .optionallyWith(
        associationId.map(value =>
          DirectConnectGatewayAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        addAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addAllowedPrefixesToDirectConnectGateway)
      .optionallyWith(
        removeAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeAllowedPrefixesToDirectConnectGateway)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest.ReadOnly =
    zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateDirectConnectGatewayAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest =
      zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest(
        associationId.map(value => value),
        addAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associationId: Optional[DirectConnectGatewayAssociationId]
    def addAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def removeAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def getAssociationId
        : ZIO[Any, AwsError, DirectConnectGatewayAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAddAllowedPrefixesToDirectConnectGateway: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "addAllowedPrefixesToDirectConnectGateway",
      addAllowedPrefixesToDirectConnectGateway
    )
    def getRemoveAllowedPrefixesToDirectConnectGateway: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "removeAllowedPrefixesToDirectConnectGateway",
      removeAllowedPrefixesToDirectConnectGateway
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
  ) extends zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest.ReadOnly {
    override val associationId: Optional[DirectConnectGatewayAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .DirectConnectGatewayAssociationId(value)
        )
    override val addAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.addAllowedPrefixesToDirectConnectGateway())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
    override val removeAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.removeAllowedPrefixesToDirectConnectGateway())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
  ): zio.aws.directconnect.model.UpdateDirectConnectGatewayAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
