package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  VLAN,
  VirtualInterfaceName,
  MTU,
  BGPAuthKey,
  EnableSiteLink,
  ASN,
  AmazonAddress,
  CustomerAddress
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NewTransitVirtualInterface(
    virtualInterfaceName: Optional[VirtualInterfaceName] = Optional.Absent,
    vlan: Optional[VLAN] = Optional.Absent,
    asn: Optional[ASN] = Optional.Absent,
    mtu: Optional[MTU] = Optional.Absent,
    authKey: Optional[BGPAuthKey] = Optional.Absent,
    amazonAddress: Optional[AmazonAddress] = Optional.Absent,
    customerAddress: Optional[CustomerAddress] = Optional.Absent,
    addressFamily: Optional[zio.aws.directconnect.model.AddressFamily] =
      Optional.Absent,
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent,
    enableSiteLink: Optional[EnableSiteLink] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface = {
    import NewTransitVirtualInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface
      .builder()
      .optionallyWith(
        virtualInterfaceName.map(value =>
          VirtualInterfaceName.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceName)
      .optionallyWith(vlan.map(value => VLAN.unwrap(value): Integer))(_.vlan)
      .optionallyWith(asn.map(value => ASN.unwrap(value): Integer))(_.asn)
      .optionallyWith(mtu.map(value => MTU.unwrap(value): Integer))(_.mtu)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableSiteLink.map(value =>
          EnableSiteLink.unwrap(value): java.lang.Boolean
        )
      )(_.enableSiteLink)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.NewTransitVirtualInterface.ReadOnly =
    zio.aws.directconnect.model.NewTransitVirtualInterface.wrap(buildAwsValue())
}
object NewTransitVirtualInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.NewTransitVirtualInterface =
      zio.aws.directconnect.model.NewTransitVirtualInterface(
        virtualInterfaceName.map(value => value),
        vlan.map(value => value),
        asn.map(value => value),
        mtu.map(value => value),
        authKey.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value),
        addressFamily.map(value => value),
        directConnectGatewayId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableSiteLink.map(value => value)
      )
    def virtualInterfaceName: Optional[VirtualInterfaceName]
    def vlan: Optional[VLAN]
    def asn: Optional[ASN]
    def mtu: Optional[MTU]
    def authKey: Optional[BGPAuthKey]
    def amazonAddress: Optional[AmazonAddress]
    def customerAddress: Optional[CustomerAddress]
    def addressFamily: Optional[zio.aws.directconnect.model.AddressFamily]
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def enableSiteLink: Optional[EnableSiteLink]
    def getVirtualInterfaceName: ZIO[Any, AwsError, VirtualInterfaceName] =
      AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceName)
    def getVlan: ZIO[Any, AwsError, VLAN] =
      AwsError.unwrapOptionField("vlan", vlan)
    def getAsn: ZIO[Any, AwsError, ASN] = AwsError.unwrapOptionField("asn", asn)
    def getMtu: ZIO[Any, AwsError, MTU] = AwsError.unwrapOptionField("mtu", mtu)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableSiteLink: ZIO[Any, AwsError, EnableSiteLink] =
      AwsError.unwrapOptionField("enableSiteLink", enableSiteLink)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface
  ) extends zio.aws.directconnect.model.NewTransitVirtualInterface.ReadOnly {
    override val virtualInterfaceName: Optional[VirtualInterfaceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceName())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceName(value)
        )
    override val vlan: Optional[VLAN] = zio.aws.core.internal
      .optionalFromNullable(impl.vlan())
      .map(value => zio.aws.directconnect.model.primitives.VLAN(value))
    override val asn: Optional[ASN] = zio.aws.core.internal
      .optionalFromNullable(impl.asn())
      .map(value => zio.aws.directconnect.model.primitives.ASN(value))
    override val mtu: Optional[MTU] = zio.aws.core.internal
      .optionalFromNullable(impl.mtu())
      .map(value => zio.aws.directconnect.model.primitives.MTU(value))
    override val authKey: Optional[BGPAuthKey] = zio.aws.core.internal
      .optionalFromNullable(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val amazonAddress: Optional[AmazonAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Optional[CustomerAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerAddress())
        .map(value =>
          zio.aws.directconnect.model.primitives.CustomerAddress(value)
        )
    override val addressFamily
        : Optional[zio.aws.directconnect.model.AddressFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressFamily())
        .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val enableSiteLink: Optional[EnableSiteLink] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSiteLink())
        .map(value =>
          zio.aws.directconnect.model.primitives.EnableSiteLink(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterface
  ): zio.aws.directconnect.model.NewTransitVirtualInterface.ReadOnly =
    new Wrapper(impl)
}
