package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  VLAN,
  VirtualInterfaceName,
  MTU,
  BGPAuthKey,
  ASN,
  AmazonAddress,
  CustomerAddress
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NewPrivateVirtualInterfaceAllocation(
    virtualInterfaceName: VirtualInterfaceName,
    vlan: VLAN,
    asn: ASN,
    mtu: Optional[MTU] = Optional.Absent,
    authKey: Optional[BGPAuthKey] = Optional.Absent,
    amazonAddress: Optional[AmazonAddress] = Optional.Absent,
    addressFamily: Optional[zio.aws.directconnect.model.AddressFamily] =
      Optional.Absent,
    customerAddress: Optional[CustomerAddress] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation = {
    import NewPrivateVirtualInterfaceAllocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation
      .builder()
      .virtualInterfaceName(
        VirtualInterfaceName.unwrap(virtualInterfaceName): java.lang.String
      )
      .vlan(VLAN.unwrap(vlan): Integer)
      .asn(ASN.unwrap(asn): Integer)
      .optionallyWith(mtu.map(value => MTU.unwrap(value): Integer))(_.mtu)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation.ReadOnly =
    zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation
      .wrap(buildAwsValue())
}
object NewPrivateVirtualInterfaceAllocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation =
      zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation(
        virtualInterfaceName,
        vlan,
        asn,
        mtu.map(value => value),
        authKey.map(value => value),
        amazonAddress.map(value => value),
        addressFamily.map(value => value),
        customerAddress.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def virtualInterfaceName: VirtualInterfaceName
    def vlan: VLAN
    def asn: ASN
    def mtu: Optional[MTU]
    def authKey: Optional[BGPAuthKey]
    def amazonAddress: Optional[AmazonAddress]
    def addressFamily: Optional[zio.aws.directconnect.model.AddressFamily]
    def customerAddress: Optional[CustomerAddress]
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def getVirtualInterfaceName: ZIO[Any, Nothing, VirtualInterfaceName] =
      ZIO.succeed(virtualInterfaceName)
    def getVlan: ZIO[Any, Nothing, VLAN] = ZIO.succeed(vlan)
    def getAsn: ZIO[Any, Nothing, ASN] = ZIO.succeed(asn)
    def getMtu: ZIO[Any, AwsError, MTU] = AwsError.unwrapOptionField("mtu", mtu)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation
  ) extends zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation.ReadOnly {
    override val virtualInterfaceName: VirtualInterfaceName =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceName(impl.virtualInterfaceName())
    override val vlan: VLAN =
      zio.aws.directconnect.model.primitives.VLAN(impl.vlan())
    override val asn: ASN =
      zio.aws.directconnect.model.primitives.ASN(impl.asn())
    override val mtu: Optional[MTU] = zio.aws.core.internal
      .optionalFromNullable(impl.mtu())
      .map(value => zio.aws.directconnect.model.primitives.MTU(value))
    override val authKey: Optional[BGPAuthKey] = zio.aws.core.internal
      .optionalFromNullable(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val amazonAddress: Optional[AmazonAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val addressFamily
        : Optional[zio.aws.directconnect.model.AddressFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressFamily())
        .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val customerAddress: Optional[CustomerAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerAddress())
        .map(value =>
          zio.aws.directconnect.model.primitives.CustomerAddress(value)
        )
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterfaceAllocation
  ): zio.aws.directconnect.model.NewPrivateVirtualInterfaceAllocation.ReadOnly =
    new Wrapper(impl)
}
