package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  StartOnDate,
  State,
  Ckn,
  SecretARN
}
import scala.jdk.CollectionConverters._
final case class MacSecKey(
    secretARN: Optional[SecretARN] = Optional.Absent,
    ckn: Optional[Ckn] = Optional.Absent,
    state: Optional[State] = Optional.Absent,
    startOn: Optional[StartOnDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.MacSecKey = {
    import MacSecKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.MacSecKey
      .builder()
      .optionallyWith(
        secretARN.map(value => SecretARN.unwrap(value): java.lang.String)
      )(_.secretARN)
      .optionallyWith(ckn.map(value => Ckn.unwrap(value): java.lang.String))(
        _.ckn
      )
      .optionallyWith(
        state.map(value => State.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        startOn.map(value => StartOnDate.unwrap(value): java.lang.String)
      )(_.startOn)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.MacSecKey.ReadOnly =
    zio.aws.directconnect.model.MacSecKey.wrap(buildAwsValue())
}
object MacSecKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.MacSecKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.MacSecKey =
      zio.aws.directconnect.model.MacSecKey(
        secretARN.map(value => value),
        ckn.map(value => value),
        state.map(value => value),
        startOn.map(value => value)
      )
    def secretARN: Optional[SecretARN]
    def ckn: Optional[Ckn]
    def state: Optional[State]
    def startOn: Optional[StartOnDate]
    def getSecretARN: ZIO[Any, AwsError, SecretARN] =
      AwsError.unwrapOptionField("secretARN", secretARN)
    def getCkn: ZIO[Any, AwsError, Ckn] = AwsError.unwrapOptionField("ckn", ckn)
    def getState: ZIO[Any, AwsError, State] =
      AwsError.unwrapOptionField("state", state)
    def getStartOn: ZIO[Any, AwsError, StartOnDate] =
      AwsError.unwrapOptionField("startOn", startOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.MacSecKey
  ) extends zio.aws.directconnect.model.MacSecKey.ReadOnly {
    override val secretARN: Optional[SecretARN] = zio.aws.core.internal
      .optionalFromNullable(impl.secretARN())
      .map(value => zio.aws.directconnect.model.primitives.SecretARN(value))
    override val ckn: Optional[Ckn] = zio.aws.core.internal
      .optionalFromNullable(impl.ckn())
      .map(value => zio.aws.directconnect.model.primitives.Ckn(value))
    override val state: Optional[State] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.directconnect.model.primitives.State(value))
    override val startOn: Optional[StartOnDate] = zio.aws.core.internal
      .optionalFromNullable(impl.startOn())
      .map(value => zio.aws.directconnect.model.primitives.StartOnDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.MacSecKey
  ): zio.aws.directconnect.model.MacSecKey.ReadOnly = new Wrapper(impl)
}
