package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListVirtualInterfaceTestHistoryResponse(
    virtualInterfaceTestHistory: Optional[
      Iterable[zio.aws.directconnect.model.VirtualInterfaceTestHistory]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse = {
    import ListVirtualInterfaceTestHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse
      .builder()
      .optionallyWith(
        virtualInterfaceTestHistory.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.virtualInterfaceTestHistory)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly =
    zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse
      .wrap(buildAwsValue())
}
object ListVirtualInterfaceTestHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse =
      zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse(
        virtualInterfaceTestHistory.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def virtualInterfaceTestHistory: Optional[
      List[zio.aws.directconnect.model.VirtualInterfaceTestHistory.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getVirtualInterfaceTestHistory: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.VirtualInterfaceTestHistory.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "virtualInterfaceTestHistory",
      virtualInterfaceTestHistory
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse
  ) extends zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly {
    override val virtualInterfaceTestHistory: Optional[
      List[zio.aws.directconnect.model.VirtualInterfaceTestHistory.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualInterfaceTestHistory())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.VirtualInterfaceTestHistory.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse
  ): zio.aws.directconnect.model.ListVirtualInterfaceTestHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
