package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait InterconnectState {
  def unwrap
      : software.amazon.awssdk.services.directconnect.model.InterconnectState
}
object InterconnectState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.InterconnectState
  ): zio.aws.directconnect.model.InterconnectState = value match {
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.REQUESTED =>
      val r = requested
      r
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.DOWN =>
      val r = down
      r
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN_TO_SDK_VERSION
  }
  case object requested extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.REQUESTED
  }
  case object pending extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.PENDING
  }
  case object available extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.AVAILABLE
  }
  case object down extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.DOWN
  }
  case object deleting extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETING
  }
  case object deleted extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.DELETED
  }
  case object unknown extends zio.aws.directconnect.model.InterconnectState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.InterconnectState =
      software.amazon.awssdk.services.directconnect.model.InterconnectState.UNKNOWN
  }
}
