package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait HasLogicalRedundancy {
  def unwrap
      : software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy
}
object HasLogicalRedundancy {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy
  ): zio.aws.directconnect.model.HasLogicalRedundancy = value match {
    case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN =>
      val r = unknown
      r
    case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.YES =>
      val r = yes
      r
    case software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.NO =>
      val r = no
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.HasLogicalRedundancy {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy =
      software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN_TO_SDK_VERSION
  }
  case object unknown extends zio.aws.directconnect.model.HasLogicalRedundancy {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy =
      software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.UNKNOWN
  }
  case object yes extends zio.aws.directconnect.model.HasLogicalRedundancy {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy =
      software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.YES
  }
  case object no extends zio.aws.directconnect.model.HasLogicalRedundancy {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy =
      software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy.NO
  }
}
