package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters._
final case class DisassociateMacSecKeyResponse(
    connectionId: Optional[ConnectionId] = Optional.Absent,
    macSecKeys: Optional[Iterable[zio.aws.directconnect.model.MacSecKey]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse = {
    import DisassociateMacSecKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse
      .builder()
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        macSecKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.macSecKeys)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly =
    zio.aws.directconnect.model.DisassociateMacSecKeyResponse
      .wrap(buildAwsValue())
}
object DisassociateMacSecKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DisassociateMacSecKeyResponse =
      zio.aws.directconnect.model.DisassociateMacSecKeyResponse(
        connectionId.map(value => value),
        macSecKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionId: Optional[ConnectionId]
    def macSecKeys
        : Optional[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]]
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getMacSecKeys: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.MacSecKey.ReadOnly
    ]] = AwsError.unwrapOptionField("macSecKeys", macSecKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse
  ) extends zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly {
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val macSecKeys
        : Optional[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macSecKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.MacSecKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse
  ): zio.aws.directconnect.model.DisassociateMacSecKeyResponse.ReadOnly =
    new Wrapper(impl)
}
