package zio.aws.directconnect.model
import scala.jdk.CollectionConverters._
sealed trait DirectConnectGatewayState {
  def unwrap: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState
}
object DirectConnectGatewayState {
  def wrap(
      value: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState
  ): zio.aws.directconnect.model.DirectConnectGatewayState = value match {
    case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.directconnect.model.DirectConnectGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending
      extends zio.aws.directconnect.model.DirectConnectGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.PENDING
  }
  case object available
      extends zio.aws.directconnect.model.DirectConnectGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.AVAILABLE
  }
  case object deleting
      extends zio.aws.directconnect.model.DirectConnectGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETING
  }
  case object deleted
      extends zio.aws.directconnect.model.DirectConnectGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState =
      software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState.DELETED
  }
}
