package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  OwnerAccount,
  DirectConnectGatewayId,
  DirectConnectGatewayAssociationProposalId
}
import scala.jdk.CollectionConverters._
final case class DirectConnectGatewayAssociationProposal(
    proposalId: Optional[DirectConnectGatewayAssociationProposalId] =
      Optional.Absent,
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    directConnectGatewayOwnerAccount: Optional[OwnerAccount] = Optional.Absent,
    proposalState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposalState
    ] = Optional.Absent,
    associatedGateway: Optional[zio.aws.directconnect.model.AssociatedGateway] =
      Optional.Absent,
    existingAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent,
    requestedAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal = {
    import DirectConnectGatewayAssociationProposal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal
      .builder()
      .optionallyWith(
        proposalId.map(value =>
          DirectConnectGatewayAssociationProposalId.unwrap(
            value
          ): java.lang.String
        )
      )(_.proposalId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        directConnectGatewayOwnerAccount.map(value =>
          OwnerAccount.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayOwnerAccount)
      .optionallyWith(proposalState.map(value => value.unwrap))(_.proposalState)
      .optionallyWith(associatedGateway.map(value => value.buildAwsValue()))(
        _.associatedGateway
      )
      .optionallyWith(
        existingAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.existingAllowedPrefixesToDirectConnectGateway)
      .optionallyWith(
        requestedAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requestedAllowedPrefixesToDirectConnectGateway)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly =
    zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal
      .wrap(buildAwsValue())
}
object DirectConnectGatewayAssociationProposal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal =
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal(
        proposalId.map(value => value),
        directConnectGatewayId.map(value => value),
        directConnectGatewayOwnerAccount.map(value => value),
        proposalState.map(value => value),
        associatedGateway.map(value => value.asEditable),
        existingAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestedAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def proposalId: Optional[DirectConnectGatewayAssociationProposalId]
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def directConnectGatewayOwnerAccount: Optional[OwnerAccount]
    def proposalState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposalState
    ]
    def associatedGateway
        : Optional[zio.aws.directconnect.model.AssociatedGateway.ReadOnly]
    def existingAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def requestedAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def getProposalId
        : ZIO[Any, AwsError, DirectConnectGatewayAssociationProposalId] =
      AwsError.unwrapOptionField("proposalId", proposalId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getDirectConnectGatewayOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField(
        "directConnectGatewayOwnerAccount",
        directConnectGatewayOwnerAccount
      )
    def getProposalState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposalState
    ] = AwsError.unwrapOptionField("proposalState", proposalState)
    def getAssociatedGateway: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.AssociatedGateway.ReadOnly
    ] = AwsError.unwrapOptionField("associatedGateway", associatedGateway)
    def getExistingAllowedPrefixesToDirectConnectGateway
        : ZIO[Any, AwsError, List[
          zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "existingAllowedPrefixesToDirectConnectGateway",
      existingAllowedPrefixesToDirectConnectGateway
    )
    def getRequestedAllowedPrefixesToDirectConnectGateway
        : ZIO[Any, AwsError, List[
          zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "requestedAllowedPrefixesToDirectConnectGateway",
      requestedAllowedPrefixesToDirectConnectGateway
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal
  ) extends zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly {
    override val proposalId
        : Optional[DirectConnectGatewayAssociationProposalId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proposalId())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .DirectConnectGatewayAssociationProposalId(value)
        )
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val directConnectGatewayOwnerAccount: Optional[OwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayOwnerAccount())
        .map(value =>
          zio.aws.directconnect.model.primitives.OwnerAccount(value)
        )
    override val proposalState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposalState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proposalState())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAssociationProposalState
          .wrap(value)
      )
    override val associatedGateway
        : Optional[zio.aws.directconnect.model.AssociatedGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedGateway())
        .map(value => zio.aws.directconnect.model.AssociatedGateway.wrap(value))
    override val existingAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.existingAllowedPrefixesToDirectConnectGateway()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
    override val requestedAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.requestedAllowedPrefixesToDirectConnectGateway()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal
  ): zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly =
    new Wrapper(impl)
}
