package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  OwnerAccount,
  VirtualGatewayRegion,
  StateChangeError,
  VirtualGatewayId,
  DirectConnectGatewayAssociationId
}
import scala.jdk.CollectionConverters._
final case class DirectConnectGatewayAssociation(
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    directConnectGatewayOwnerAccount: Optional[OwnerAccount] = Optional.Absent,
    associationState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationState
    ] = Optional.Absent,
    stateChangeError: Optional[StateChangeError] = Optional.Absent,
    associatedGateway: Optional[zio.aws.directconnect.model.AssociatedGateway] =
      Optional.Absent,
    associationId: Optional[DirectConnectGatewayAssociationId] =
      Optional.Absent,
    allowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent,
    virtualGatewayId: Optional[VirtualGatewayId] = Optional.Absent,
    virtualGatewayRegion: Optional[VirtualGatewayRegion] = Optional.Absent,
    virtualGatewayOwnerAccount: Optional[OwnerAccount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation = {
    import DirectConnectGatewayAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation
      .builder()
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        directConnectGatewayOwnerAccount.map(value =>
          OwnerAccount.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayOwnerAccount)
      .optionallyWith(associationState.map(value => value.unwrap))(
        _.associationState
      )
      .optionallyWith(
        stateChangeError.map(value =>
          StateChangeError.unwrap(value): java.lang.String
        )
      )(_.stateChangeError)
      .optionallyWith(associatedGateway.map(value => value.buildAwsValue()))(
        _.associatedGateway
      )
      .optionallyWith(
        associationId.map(value =>
          DirectConnectGatewayAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        allowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allowedPrefixesToDirectConnectGateway)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .optionallyWith(
        virtualGatewayRegion.map(value =>
          VirtualGatewayRegion.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayRegion)
      .optionallyWith(
        virtualGatewayOwnerAccount.map(value =>
          OwnerAccount.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayOwnerAccount)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly =
    zio.aws.directconnect.model.DirectConnectGatewayAssociation
      .wrap(buildAwsValue())
}
object DirectConnectGatewayAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DirectConnectGatewayAssociation =
      zio.aws.directconnect.model.DirectConnectGatewayAssociation(
        directConnectGatewayId.map(value => value),
        directConnectGatewayOwnerAccount.map(value => value),
        associationState.map(value => value),
        stateChangeError.map(value => value),
        associatedGateway.map(value => value.asEditable),
        associationId.map(value => value),
        allowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        virtualGatewayId.map(value => value),
        virtualGatewayRegion.map(value => value),
        virtualGatewayOwnerAccount.map(value => value)
      )
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def directConnectGatewayOwnerAccount: Optional[OwnerAccount]
    def associationState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationState
    ]
    def stateChangeError: Optional[StateChangeError]
    def associatedGateway
        : Optional[zio.aws.directconnect.model.AssociatedGateway.ReadOnly]
    def associationId: Optional[DirectConnectGatewayAssociationId]
    def allowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def virtualGatewayId: Optional[VirtualGatewayId]
    def virtualGatewayRegion: Optional[VirtualGatewayRegion]
    def virtualGatewayOwnerAccount: Optional[OwnerAccount]
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getDirectConnectGatewayOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField(
        "directConnectGatewayOwnerAccount",
        directConnectGatewayOwnerAccount
      )
    def getAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAssociationState
    ] = AwsError.unwrapOptionField("associationState", associationState)
    def getStateChangeError: ZIO[Any, AwsError, StateChangeError] =
      AwsError.unwrapOptionField("stateChangeError", stateChangeError)
    def getAssociatedGateway: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.AssociatedGateway.ReadOnly
    ] = AwsError.unwrapOptionField("associatedGateway", associatedGateway)
    def getAssociationId
        : ZIO[Any, AwsError, DirectConnectGatewayAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAllowedPrefixesToDirectConnectGateway: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "allowedPrefixesToDirectConnectGateway",
      allowedPrefixesToDirectConnectGateway
    )
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
    def getVirtualGatewayRegion: ZIO[Any, AwsError, VirtualGatewayRegion] =
      AwsError.unwrapOptionField("virtualGatewayRegion", virtualGatewayRegion)
    def getVirtualGatewayOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField(
        "virtualGatewayOwnerAccount",
        virtualGatewayOwnerAccount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation
  ) extends zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly {
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val directConnectGatewayOwnerAccount: Optional[OwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayOwnerAccount())
        .map(value =>
          zio.aws.directconnect.model.primitives.OwnerAccount(value)
        )
    override val associationState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associationState())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAssociationState
          .wrap(value)
      )
    override val stateChangeError: Optional[StateChangeError] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeError())
        .map(value =>
          zio.aws.directconnect.model.primitives.StateChangeError(value)
        )
    override val associatedGateway
        : Optional[zio.aws.directconnect.model.AssociatedGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedGateway())
        .map(value => zio.aws.directconnect.model.AssociatedGateway.wrap(value))
    override val associationId: Optional[DirectConnectGatewayAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .DirectConnectGatewayAssociationId(value)
        )
    override val allowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedPrefixesToDirectConnectGateway())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
    override val virtualGatewayId: Optional[VirtualGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
        )
    override val virtualGatewayRegion: Optional[VirtualGatewayRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualGatewayRegion())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualGatewayRegion(value)
        )
    override val virtualGatewayOwnerAccount: Optional[OwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualGatewayOwnerAccount())
        .map(value =>
          zio.aws.directconnect.model.primitives.OwnerAccount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation
  ): zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly =
    new Wrapper(impl)
}
