package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  OwnerAccount,
  DirectConnectGatewayName,
  LongAsn,
  StateChangeError
}
import scala.jdk.CollectionConverters._
final case class DirectConnectGateway(
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    directConnectGatewayName: Optional[DirectConnectGatewayName] =
      Optional.Absent,
    amazonSideAsn: Optional[LongAsn] = Optional.Absent,
    ownerAccount: Optional[OwnerAccount] = Optional.Absent,
    directConnectGatewayState: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayState
    ] = Optional.Absent,
    stateChangeError: Optional[StateChangeError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DirectConnectGateway = {
    import DirectConnectGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DirectConnectGateway
      .builder()
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        directConnectGatewayName.map(value =>
          DirectConnectGatewayName.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayName)
      .optionallyWith(
        amazonSideAsn.map(value => LongAsn.unwrap(value): java.lang.Long)
      )(_.amazonSideAsn)
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(directConnectGatewayState.map(value => value.unwrap))(
        _.directConnectGatewayState
      )
      .optionallyWith(
        stateChangeError.map(value =>
          StateChangeError.unwrap(value): java.lang.String
        )
      )(_.stateChangeError)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DirectConnectGateway.ReadOnly =
    zio.aws.directconnect.model.DirectConnectGateway.wrap(buildAwsValue())
}
object DirectConnectGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DirectConnectGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DirectConnectGateway =
      zio.aws.directconnect.model.DirectConnectGateway(
        directConnectGatewayId.map(value => value),
        directConnectGatewayName.map(value => value),
        amazonSideAsn.map(value => value),
        ownerAccount.map(value => value),
        directConnectGatewayState.map(value => value),
        stateChangeError.map(value => value)
      )
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def directConnectGatewayName: Optional[DirectConnectGatewayName]
    def amazonSideAsn: Optional[LongAsn]
    def ownerAccount: Optional[OwnerAccount]
    def directConnectGatewayState
        : Optional[zio.aws.directconnect.model.DirectConnectGatewayState]
    def stateChangeError: Optional[StateChangeError]
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getDirectConnectGatewayName
        : ZIO[Any, AwsError, DirectConnectGatewayName] = AwsError
      .unwrapOptionField("directConnectGatewayName", directConnectGatewayName)
    def getAmazonSideAsn: ZIO[Any, AwsError, LongAsn] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getDirectConnectGatewayState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayState
    ] = AwsError.unwrapOptionField(
      "directConnectGatewayState",
      directConnectGatewayState
    )
    def getStateChangeError: ZIO[Any, AwsError, StateChangeError] =
      AwsError.unwrapOptionField("stateChangeError", stateChangeError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGateway
  ) extends zio.aws.directconnect.model.DirectConnectGateway.ReadOnly {
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val directConnectGatewayName: Optional[DirectConnectGatewayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayName())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayName(value)
        )
    override val amazonSideAsn: Optional[LongAsn] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonSideAsn())
      .map(value => zio.aws.directconnect.model.primitives.LongAsn(value))
    override val ownerAccount: Optional[OwnerAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val directConnectGatewayState
        : Optional[zio.aws.directconnect.model.DirectConnectGatewayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayState())
        .map(value =>
          zio.aws.directconnect.model.DirectConnectGatewayState.wrap(value)
        )
    override val stateChangeError: Optional[StateChangeError] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeError())
        .map(value =>
          zio.aws.directconnect.model.primitives.StateChangeError(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DirectConnectGateway
  ): zio.aws.directconnect.model.DirectConnectGateway.ReadOnly = new Wrapper(
    impl
  )
}
