package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVirtualInterfacesResponse(
    virtualInterfaces: Optional[
      Iterable[zio.aws.directconnect.model.VirtualInterface]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse = {
    import DescribeVirtualInterfacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse
      .builder()
      .optionallyWith(
        virtualInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.virtualInterfaces)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeVirtualInterfacesResponse
      .wrap(buildAwsValue())
}
object DescribeVirtualInterfacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeVirtualInterfacesResponse =
      zio.aws.directconnect.model.DescribeVirtualInterfacesResponse(
        virtualInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def virtualInterfaces
        : Optional[List[zio.aws.directconnect.model.VirtualInterface.ReadOnly]]
    def getVirtualInterfaces: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.VirtualInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("virtualInterfaces", virtualInterfaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse
  ) extends zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly {
    override val virtualInterfaces: Optional[
      List[zio.aws.directconnect.model.VirtualInterface.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.VirtualInterface.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse
  ): zio.aws.directconnect.model.DescribeVirtualInterfacesResponse.ReadOnly =
    new Wrapper(impl)
}
