package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{VirtualInterfaceId, ConnectionId}
import scala.jdk.CollectionConverters._
final case class DescribeVirtualInterfacesRequest(
    connectionId: Optional[ConnectionId] = Optional.Absent,
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest = {
    import DescribeVirtualInterfacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
      .builder()
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeVirtualInterfacesRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeVirtualInterfacesRequest
      .wrap(buildAwsValue())
}
object DescribeVirtualInterfacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeVirtualInterfacesRequest =
      zio.aws.directconnect.model.DescribeVirtualInterfacesRequest(
        connectionId.map(value => value),
        virtualInterfaceId.map(value => value)
      )
    def connectionId: Optional[ConnectionId]
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
  ) extends zio.aws.directconnect.model.DescribeVirtualInterfacesRequest.ReadOnly {
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest
  ): zio.aws.directconnect.model.DescribeVirtualInterfacesRequest.ReadOnly =
    new Wrapper(impl)
}
