package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLagsResponse(
    lags: Optional[Iterable[zio.aws.directconnect.model.Lag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse = {
    import DescribeLagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse
      .builder()
      .optionallyWith(
        lags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lags)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeLagsResponse.wrap(buildAwsValue())
}
object DescribeLagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeLagsResponse =
      zio.aws.directconnect.model.DescribeLagsResponse(
        lags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lags: Optional[List[zio.aws.directconnect.model.Lag.ReadOnly]]
    def getLags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Lag.ReadOnly]] =
      AwsError.unwrapOptionField("lags", lags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse
  ) extends zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly {
    override val lags
        : Optional[List[zio.aws.directconnect.model.Lag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Lag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse
  ): zio.aws.directconnect.model.DescribeLagsResponse.ReadOnly = new Wrapper(
    impl
  )
}
