package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.LagId
import scala.jdk.CollectionConverters._
final case class DescribeLagsRequest(lagId: Optional[LagId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest = {
    import DescribeLagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
      .builder()
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.DescribeLagsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeLagsRequest.wrap(buildAwsValue())
}
object DescribeLagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeLagsRequest =
      zio.aws.directconnect.model.DescribeLagsRequest(lagId.map(value => value))
    def lagId: Optional[LagId]
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
  ) extends zio.aws.directconnect.model.DescribeLagsRequest.ReadOnly {
    override val lagId: Optional[LagId] = zio.aws.core.internal
      .optionalFromNullable(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest
  ): zio.aws.directconnect.model.DescribeLagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
