package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInterconnectsResponse(
    interconnects: Optional[
      Iterable[zio.aws.directconnect.model.Interconnect]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse = {
    import DescribeInterconnectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse
      .builder()
      .optionallyWith(
        interconnects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.interconnects)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeInterconnectsResponse
      .wrap(buildAwsValue())
}
object DescribeInterconnectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeInterconnectsResponse =
      zio.aws.directconnect.model.DescribeInterconnectsResponse(
        interconnects.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def interconnects
        : Optional[List[zio.aws.directconnect.model.Interconnect.ReadOnly]]
    def getInterconnects: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.Interconnect.ReadOnly
    ]] = AwsError.unwrapOptionField("interconnects", interconnects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse
  ) extends zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly {
    override val interconnects
        : Optional[List[zio.aws.directconnect.model.Interconnect.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interconnects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Interconnect.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse
  ): zio.aws.directconnect.model.DescribeInterconnectsResponse.ReadOnly =
    new Wrapper(impl)
}
