package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHostedConnectionsResponse(
    connections: Optional[Iterable[zio.aws.directconnect.model.Connection]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse = {
    import DescribeHostedConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeHostedConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeHostedConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeHostedConnectionsResponse =
      zio.aws.directconnect.model.DescribeHostedConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connections
        : Optional[List[zio.aws.directconnect.model.Connection.ReadOnly]]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse
  ) extends zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly {
    override val connections
        : Optional[List[zio.aws.directconnect.model.Connection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Connection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse
  ): zio.aws.directconnect.model.DescribeHostedConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
