package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewaysResponse(
    directConnectGateways: Optional[
      Iterable[zio.aws.directconnect.model.DirectConnectGateway]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse = {
    import DescribeDirectConnectGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse
      .builder()
      .optionallyWith(
        directConnectGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directConnectGateways)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse =
      zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse(
        directConnectGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def directConnectGateways: Optional[
      List[zio.aws.directconnect.model.DirectConnectGateway.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getDirectConnectGateways: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.DirectConnectGateway.ReadOnly
    ]] =
      AwsError.unwrapOptionField("directConnectGateways", directConnectGateways)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly {
    override val directConnectGateways: Optional[
      List[zio.aws.directconnect.model.DirectConnectGateway.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.directConnectGateways())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.DirectConnectGateway.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewaysResponse.ReadOnly =
    new Wrapper(impl)
}
