package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  PaginationToken,
  MaxResultSetSize,
  VirtualInterfaceId,
  DirectConnectGatewayId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAttachmentsRequest(
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent,
    maxResults: Optional[MaxResultSetSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest = {
    import DescribeDirectConnectGatewayAttachmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
      .builder()
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        maxResults.map(value => MaxResultSetSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAttachmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAttachmentsRequest(
          directConnectGatewayId.map(value => value),
          virtualInterfaceId.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def maxResults: Optional[MaxResultSetSize]
    def nextToken: Optional[PaginationToken]
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResultSetSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest.ReadOnly {
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
    override val maxResults: Optional[MaxResultSetSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.directconnect.model.primitives.MaxResultSetSize(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest.ReadOnly =
    new Wrapper(impl)
}
