package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAssociationsResponse(
    directConnectGatewayAssociations: Optional[
      Iterable[zio.aws.directconnect.model.DirectConnectGatewayAssociation]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse = {
    import DescribeDirectConnectGatewayAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directConnectGatewayAssociations)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAssociationsResponse(
          directConnectGatewayAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def directConnectGatewayAssociations: Optional[
      List[zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getDirectConnectGatewayAssociations: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "directConnectGatewayAssociations",
      directConnectGatewayAssociations
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly {
    override val directConnectGatewayAssociations: Optional[
      List[zio.aws.directconnect.model.DirectConnectGatewayAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.directConnectGatewayAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.DirectConnectGatewayAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
