package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  AssociatedGatewayId,
  PaginationToken,
  VirtualGatewayId,
  MaxResultSetSize,
  DirectConnectGatewayAssociationId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAssociationsRequest(
    associationId: Optional[DirectConnectGatewayAssociationId] =
      Optional.Absent,
    associatedGatewayId: Optional[AssociatedGatewayId] = Optional.Absent,
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    maxResults: Optional[MaxResultSetSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    virtualGatewayId: Optional[VirtualGatewayId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest = {
    import DescribeDirectConnectGatewayAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
      .builder()
      .optionallyWith(
        associationId.map(value =>
          DirectConnectGatewayAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associatedGatewayId.map(value =>
          AssociatedGatewayId.unwrap(value): java.lang.String
        )
      )(_.associatedGatewayId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        maxResults.map(value => MaxResultSetSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAssociationsRequest(
          associationId.map(value => value),
          associatedGatewayId.map(value => value),
          directConnectGatewayId.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value),
          virtualGatewayId.map(value => value)
        )
    def associationId: Optional[DirectConnectGatewayAssociationId]
    def associatedGatewayId: Optional[AssociatedGatewayId]
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def maxResults: Optional[MaxResultSetSize]
    def nextToken: Optional[PaginationToken]
    def virtualGatewayId: Optional[VirtualGatewayId]
    def getAssociationId
        : ZIO[Any, AwsError, DirectConnectGatewayAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociatedGatewayId: ZIO[Any, AwsError, AssociatedGatewayId] =
      AwsError.unwrapOptionField("associatedGatewayId", associatedGatewayId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResultSetSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.ReadOnly {
    override val associationId: Optional[DirectConnectGatewayAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .DirectConnectGatewayAssociationId(value)
        )
    override val associatedGatewayId: Optional[AssociatedGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.AssociatedGatewayId(value)
        )
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val maxResults: Optional[MaxResultSetSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.directconnect.model.primitives.MaxResultSetSize(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
    override val virtualGatewayId: Optional[VirtualGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
