package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAssociationProposalsResponse(
    directConnectGatewayAssociationProposals: Optional[Iterable[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal
    ]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse = {
    import DescribeDirectConnectGatewayAssociationProposalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAssociationProposals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directConnectGatewayAssociationProposals)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAssociationProposalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAssociationProposalsResponse(
          directConnectGatewayAssociationProposals.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def directConnectGatewayAssociationProposals: Optional[List[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly
    ]]
    def nextToken: Optional[PaginationToken]
    def getDirectConnectGatewayAssociationProposals: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "directConnectGatewayAssociationProposals",
      directConnectGatewayAssociationProposals
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly {
    override val directConnectGatewayAssociationProposals: Optional[List[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.directConnectGatewayAssociationProposals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse.ReadOnly =
    new Wrapper(impl)
}
