package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  AssociatedGatewayId,
  PaginationToken,
  DirectConnectGatewayAssociationProposalId,
  MaxResultSetSize
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDirectConnectGatewayAssociationProposalsRequest(
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent,
    proposalId: Optional[DirectConnectGatewayAssociationProposalId] =
      Optional.Absent,
    associatedGatewayId: Optional[AssociatedGatewayId] = Optional.Absent,
    maxResults: Optional[MaxResultSetSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest = {
    import DescribeDirectConnectGatewayAssociationProposalsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
      .builder()
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .optionallyWith(
        proposalId.map(value =>
          DirectConnectGatewayAssociationProposalId.unwrap(
            value
          ): java.lang.String
        )
      )(_.proposalId)
      .optionallyWith(
        associatedGatewayId.map(value =>
          AssociatedGatewayId.unwrap(value): java.lang.String
        )
      )(_.associatedGatewayId)
      .optionallyWith(
        maxResults.map(value => MaxResultSetSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest.ReadOnly =
    zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
      .wrap(buildAwsValue())
}
object DescribeDirectConnectGatewayAssociationProposalsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest =
      zio.aws.directconnect.model
        .DescribeDirectConnectGatewayAssociationProposalsRequest(
          directConnectGatewayId.map(value => value),
          proposalId.map(value => value),
          associatedGatewayId.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def proposalId: Optional[DirectConnectGatewayAssociationProposalId]
    def associatedGatewayId: Optional[AssociatedGatewayId]
    def maxResults: Optional[MaxResultSetSize]
    def nextToken: Optional[PaginationToken]
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
    def getProposalId
        : ZIO[Any, AwsError, DirectConnectGatewayAssociationProposalId] =
      AwsError.unwrapOptionField("proposalId", proposalId)
    def getAssociatedGatewayId: ZIO[Any, AwsError, AssociatedGatewayId] =
      AwsError.unwrapOptionField("associatedGatewayId", associatedGatewayId)
    def getMaxResults: ZIO[Any, AwsError, MaxResultSetSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
  ) extends zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest.ReadOnly {
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
    override val proposalId
        : Optional[DirectConnectGatewayAssociationProposalId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proposalId())
        .map(value =>
          zio.aws.directconnect.model.primitives
            .DirectConnectGatewayAssociationProposalId(value)
        )
    override val associatedGatewayId: Optional[AssociatedGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.AssociatedGatewayId(value)
        )
    override val maxResults: Optional[MaxResultSetSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.directconnect.model.primitives.MaxResultSetSize(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.directconnect.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
  ): zio.aws.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest.ReadOnly =
    new Wrapper(impl)
}
