package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeConnectionsResponse(
    connections: Optional[Iterable[zio.aws.directconnect.model.Connection]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse = {
    import DescribeConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly =
    zio.aws.directconnect.model.DescribeConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DescribeConnectionsResponse =
      zio.aws.directconnect.model.DescribeConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connections
        : Optional[List[zio.aws.directconnect.model.Connection.ReadOnly]]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse
  ) extends zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly {
    override val connections
        : Optional[List[zio.aws.directconnect.model.Connection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Connection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse
  ): zio.aws.directconnect.model.DescribeConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
