package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVirtualInterfaceResponse(
    virtualInterfaceState: Optional[
      zio.aws.directconnect.model.VirtualInterfaceState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse = {
    import DeleteVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse
      .builder()
      .optionallyWith(virtualInterfaceState.map(value => value.unwrap))(
        _.virtualInterfaceState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly =
    zio.aws.directconnect.model.DeleteVirtualInterfaceResponse
      .wrap(buildAwsValue())
}
object DeleteVirtualInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.DeleteVirtualInterfaceResponse =
      zio.aws.directconnect.model.DeleteVirtualInterfaceResponse(
        virtualInterfaceState.map(value => value)
      )
    def virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState]
    def getVirtualInterfaceState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterfaceState
    ] =
      AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse
  ) extends zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly {
    override val virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceState())
        .map(value =>
          zio.aws.directconnect.model.VirtualInterfaceState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse
  ): zio.aws.directconnect.model.DeleteVirtualInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
