package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDirectConnectGatewayAssociationProposalResponse(
    directConnectGatewayAssociationProposal: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse = {
    import DeleteDirectConnectGatewayAssociationProposalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse
      .builder()
      .optionallyWith(
        directConnectGatewayAssociationProposal.map(value =>
          value.buildAwsValue()
        )
      )(_.directConnectGatewayAssociationProposal)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly =
    zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse
      .wrap(buildAwsValue())
}
object DeleteDirectConnectGatewayAssociationProposalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse =
      zio.aws.directconnect.model
        .DeleteDirectConnectGatewayAssociationProposalResponse(
          directConnectGatewayAssociationProposal.map(value => value.asEditable)
        )
    def directConnectGatewayAssociationProposal: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly
    ]
    def getDirectConnectGatewayAssociationProposal: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly
    ] = AwsError.unwrapOptionField(
      "directConnectGatewayAssociationProposal",
      directConnectGatewayAssociationProposal
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse
  ) extends zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly {
    override val directConnectGatewayAssociationProposal: Optional[
      zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.directConnectGatewayAssociationProposal())
      .map(value =>
        zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse
  ): zio.aws.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse.ReadOnly =
    new Wrapper(impl)
}
