package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{Status, AgreementName}
import scala.jdk.CollectionConverters._
final case class CustomerAgreement(
    agreementName: Optional[AgreementName] = Optional.Absent,
    status: Optional[Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CustomerAgreement = {
    import CustomerAgreement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CustomerAgreement
      .builder()
      .optionallyWith(
        agreementName.map(value =>
          AgreementName.unwrap(value): java.lang.String
        )
      )(_.agreementName)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.CustomerAgreement.ReadOnly =
    zio.aws.directconnect.model.CustomerAgreement.wrap(buildAwsValue())
}
object CustomerAgreement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CustomerAgreement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.CustomerAgreement =
      zio.aws.directconnect.model.CustomerAgreement(
        agreementName.map(value => value),
        status.map(value => value)
      )
    def agreementName: Optional[AgreementName]
    def status: Optional[Status]
    def getAgreementName: ZIO[Any, AwsError, AgreementName] =
      AwsError.unwrapOptionField("agreementName", agreementName)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CustomerAgreement
  ) extends zio.aws.directconnect.model.CustomerAgreement.ReadOnly {
    override val agreementName: Optional[AgreementName] = zio.aws.core.internal
      .optionalFromNullable(impl.agreementName())
      .map(value => zio.aws.directconnect.model.primitives.AgreementName(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.directconnect.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CustomerAgreement
  ): zio.aws.directconnect.model.CustomerAgreement.ReadOnly = new Wrapper(impl)
}
