package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  ProviderName,
  Bandwidth,
  InterconnectName,
  LagId,
  LocationCode
}
import scala.jdk.CollectionConverters._
final case class CreateInterconnectRequest(
    interconnectName: InterconnectName,
    bandwidth: Bandwidth,
    location: LocationCode,
    lagId: Optional[LagId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent,
    providerName: Optional[ProviderName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest = {
    import CreateInterconnectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest
      .builder()
      .interconnectName(
        InterconnectName.unwrap(interconnectName): java.lang.String
      )
      .bandwidth(Bandwidth.unwrap(bandwidth): java.lang.String)
      .location(LocationCode.unwrap(location): java.lang.String)
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreateInterconnectRequest.ReadOnly =
    zio.aws.directconnect.model.CreateInterconnectRequest.wrap(buildAwsValue())
}
object CreateInterconnectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.CreateInterconnectRequest =
      zio.aws.directconnect.model.CreateInterconnectRequest(
        interconnectName,
        bandwidth,
        location,
        lagId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value)
      )
    def interconnectName: InterconnectName
    def bandwidth: Bandwidth
    def location: LocationCode
    def lagId: Optional[LagId]
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Optional[ProviderName]
    def getInterconnectName: ZIO[Any, Nothing, InterconnectName] =
      ZIO.succeed(interconnectName)
    def getBandwidth: ZIO[Any, Nothing, Bandwidth] = ZIO.succeed(bandwidth)
    def getLocation: ZIO[Any, Nothing, LocationCode] = ZIO.succeed(location)
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest
  ) extends zio.aws.directconnect.model.CreateInterconnectRequest.ReadOnly {
    override val interconnectName: InterconnectName =
      zio.aws.directconnect.model.primitives
        .InterconnectName(impl.interconnectName())
    override val bandwidth: Bandwidth =
      zio.aws.directconnect.model.primitives.Bandwidth(impl.bandwidth())
    override val location: LocationCode =
      zio.aws.directconnect.model.primitives.LocationCode(impl.location())
    override val lagId: Optional[LagId] = zio.aws.core.internal
      .optionalFromNullable(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Optional[ProviderName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest
  ): zio.aws.directconnect.model.CreateInterconnectRequest.ReadOnly =
    new Wrapper(impl)
}
