package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  LongAsn,
  DirectConnectGatewayName
}
import scala.jdk.CollectionConverters._
final case class CreateDirectConnectGatewayRequest(
    directConnectGatewayName: DirectConnectGatewayName,
    amazonSideAsn: Optional[LongAsn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest = {
    import CreateDirectConnectGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest
      .builder()
      .directConnectGatewayName(
        DirectConnectGatewayName.unwrap(
          directConnectGatewayName
        ): java.lang.String
      )
      .optionallyWith(
        amazonSideAsn.map(value => LongAsn.unwrap(value): java.lang.Long)
      )(_.amazonSideAsn)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreateDirectConnectGatewayRequest.ReadOnly =
    zio.aws.directconnect.model.CreateDirectConnectGatewayRequest
      .wrap(buildAwsValue())
}
object CreateDirectConnectGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreateDirectConnectGatewayRequest =
      zio.aws.directconnect.model.CreateDirectConnectGatewayRequest(
        directConnectGatewayName,
        amazonSideAsn.map(value => value)
      )
    def directConnectGatewayName: DirectConnectGatewayName
    def amazonSideAsn: Optional[LongAsn]
    def getDirectConnectGatewayName
        : ZIO[Any, Nothing, DirectConnectGatewayName] =
      ZIO.succeed(directConnectGatewayName)
    def getAmazonSideAsn: ZIO[Any, AwsError, LongAsn] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest
  ) extends zio.aws.directconnect.model.CreateDirectConnectGatewayRequest.ReadOnly {
    override val directConnectGatewayName: DirectConnectGatewayName =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayName(impl.directConnectGatewayName())
    override val amazonSideAsn: Optional[LongAsn] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonSideAsn())
      .map(value => zio.aws.directconnect.model.primitives.LongAsn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest
  ): zio.aws.directconnect.model.CreateDirectConnectGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
