package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  VirtualGatewayId,
  GatewayIdToAssociate,
  DirectConnectGatewayId
}
import scala.jdk.CollectionConverters._
final case class CreateDirectConnectGatewayAssociationRequest(
    directConnectGatewayId: DirectConnectGatewayId,
    gatewayId: Optional[GatewayIdToAssociate] = Optional.Absent,
    addAllowedPrefixesToDirectConnectGateway: Optional[
      Iterable[zio.aws.directconnect.model.RouteFilterPrefix]
    ] = Optional.Absent,
    virtualGatewayId: Optional[VirtualGatewayId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest = {
    import CreateDirectConnectGatewayAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest
      .builder()
      .directConnectGatewayId(
        DirectConnectGatewayId.unwrap(directConnectGatewayId): java.lang.String
      )
      .optionallyWith(
        gatewayId.map(value =>
          GatewayIdToAssociate.unwrap(value): java.lang.String
        )
      )(_.gatewayId)
      .optionallyWith(
        addAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addAllowedPrefixesToDirectConnectGateway)
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest.ReadOnly =
    zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest
      .wrap(buildAwsValue())
}
object CreateDirectConnectGatewayAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest =
      zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest(
        directConnectGatewayId,
        gatewayId.map(value => value),
        addAllowedPrefixesToDirectConnectGateway.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        virtualGatewayId.map(value => value)
      )
    def directConnectGatewayId: DirectConnectGatewayId
    def gatewayId: Optional[GatewayIdToAssociate]
    def addAllowedPrefixesToDirectConnectGateway
        : Optional[List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]]
    def virtualGatewayId: Optional[VirtualGatewayId]
    def getDirectConnectGatewayId: ZIO[Any, Nothing, DirectConnectGatewayId] =
      ZIO.succeed(directConnectGatewayId)
    def getGatewayId: ZIO[Any, AwsError, GatewayIdToAssociate] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getAddAllowedPrefixesToDirectConnectGateway: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "addAllowedPrefixesToDirectConnectGateway",
      addAllowedPrefixesToDirectConnectGateway
    )
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest
  ) extends zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest.ReadOnly {
    override val directConnectGatewayId: DirectConnectGatewayId =
      zio.aws.directconnect.model.primitives
        .DirectConnectGatewayId(impl.directConnectGatewayId())
    override val gatewayId: Optional[GatewayIdToAssociate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.GatewayIdToAssociate(value)
        )
    override val addAllowedPrefixesToDirectConnectGateway: Optional[
      List[zio.aws.directconnect.model.RouteFilterPrefix.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.addAllowedPrefixesToDirectConnectGateway())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.RouteFilterPrefix.wrap(item)
        }.toList
      )
    override val virtualGatewayId: Optional[VirtualGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest
  ): zio.aws.directconnect.model.CreateDirectConnectGatewayAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
