package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfirmTransitVirtualInterfaceResponse(
    virtualInterfaceState: Optional[
      zio.aws.directconnect.model.VirtualInterfaceState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse = {
    import ConfirmTransitVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse
      .builder()
      .optionallyWith(virtualInterfaceState.map(value => value.unwrap))(
        _.virtualInterfaceState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly =
    zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse
      .wrap(buildAwsValue())
}
object ConfirmTransitVirtualInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse =
      zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse(
        virtualInterfaceState.map(value => value)
      )
    def virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState]
    def getVirtualInterfaceState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterfaceState
    ] =
      AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse
  ) extends zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly {
    override val virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceState())
        .map(value =>
          zio.aws.directconnect.model.VirtualInterfaceState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse
  ): zio.aws.directconnect.model.ConfirmTransitVirtualInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
