package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.directconnect.model.primitives.VirtualInterfaceId
import scala.jdk.CollectionConverters._
final case class ConfirmPublicVirtualInterfaceRequest(
    virtualInterfaceId: VirtualInterfaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest = {
    import ConfirmPublicVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object ConfirmPublicVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest =
      zio.aws.directconnect.model
        .ConfirmPublicVirtualInterfaceRequest(virtualInterfaceId)
    def virtualInterfaceId: VirtualInterfaceId
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest
  ): zio.aws.directconnect.model.ConfirmPublicVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
