package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfirmPrivateVirtualInterfaceResponse(
    virtualInterfaceState: Optional[
      zio.aws.directconnect.model.VirtualInterfaceState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse = {
    import ConfirmPrivateVirtualInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse
      .builder()
      .optionallyWith(virtualInterfaceState.map(value => value.unwrap))(
        _.virtualInterfaceState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly =
    zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse
      .wrap(buildAwsValue())
}
object ConfirmPrivateVirtualInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse =
      zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse(
        virtualInterfaceState.map(value => value)
      )
    def virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState]
    def getVirtualInterfaceState: ZIO[
      Any,
      AwsError,
      zio.aws.directconnect.model.VirtualInterfaceState
    ] =
      AwsError.unwrapOptionField("virtualInterfaceState", virtualInterfaceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse
  ) extends zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly {
    override val virtualInterfaceState
        : Optional[zio.aws.directconnect.model.VirtualInterfaceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceState())
        .map(value =>
          zio.aws.directconnect.model.VirtualInterfaceState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse
  ): zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceResponse.ReadOnly =
    new Wrapper(impl)
}
