package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  DirectConnectGatewayId,
  VirtualGatewayId,
  VirtualInterfaceId
}
import scala.jdk.CollectionConverters._
final case class ConfirmPrivateVirtualInterfaceRequest(
    virtualInterfaceId: VirtualInterfaceId,
    virtualGatewayId: Optional[VirtualGatewayId] = Optional.Absent,
    directConnectGatewayId: Optional[DirectConnectGatewayId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest = {
    import ConfirmPrivateVirtualInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .optionallyWith(
        directConnectGatewayId.map(value =>
          DirectConnectGatewayId.unwrap(value): java.lang.String
        )
      )(_.directConnectGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest.ReadOnly =
    zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
      .wrap(buildAwsValue())
}
object ConfirmPrivateVirtualInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest =
      zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest(
        virtualInterfaceId,
        virtualGatewayId.map(value => value),
        directConnectGatewayId.map(value => value)
      )
    def virtualInterfaceId: VirtualInterfaceId
    def virtualGatewayId: Optional[VirtualGatewayId]
    def directConnectGatewayId: Optional[DirectConnectGatewayId]
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
    def getDirectConnectGatewayId: ZIO[Any, AwsError, DirectConnectGatewayId] =
      AwsError.unwrapOptionField(
        "directConnectGatewayId",
        directConnectGatewayId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
  ) extends zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
    override val virtualGatewayId: Optional[VirtualGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
        )
    override val directConnectGatewayId: Optional[DirectConnectGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directConnectGatewayId())
        .map(value =>
          zio.aws.directconnect.model.primitives.DirectConnectGatewayId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
  ): zio.aws.directconnect.model.ConfirmPrivateVirtualInterfaceRequest.ReadOnly =
    new Wrapper(impl)
}
