package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.{
  Region,
  OwnerAccount,
  GatewayIdentifier
}
import scala.jdk.CollectionConverters._
final case class AssociatedGateway(
    id: Optional[GatewayIdentifier] = Optional.Absent,
    `type`: Optional[zio.aws.directconnect.model.GatewayType] = Optional.Absent,
    ownerAccount: Optional[OwnerAccount] = Optional.Absent,
    region: Optional[Region] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AssociatedGateway = {
    import AssociatedGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AssociatedGateway
      .builder()
      .optionallyWith(
        id.map(value => GatewayIdentifier.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.AssociatedGateway.ReadOnly =
    zio.aws.directconnect.model.AssociatedGateway.wrap(buildAwsValue())
}
object AssociatedGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AssociatedGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.AssociatedGateway =
      zio.aws.directconnect.model.AssociatedGateway(
        id.map(value => value),
        `type`.map(value => value),
        ownerAccount.map(value => value),
        region.map(value => value)
      )
    def id: Optional[GatewayIdentifier]
    def `type`: Optional[zio.aws.directconnect.model.GatewayType]
    def ownerAccount: Optional[OwnerAccount]
    def region: Optional[Region]
    def getId: ZIO[Any, AwsError, GatewayIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.directconnect.model.GatewayType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AssociatedGateway
  ) extends zio.aws.directconnect.model.AssociatedGateway.ReadOnly {
    override val id: Optional[GatewayIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.directconnect.model.primitives.GatewayIdentifier(value)
      )
    override val `type`: Optional[zio.aws.directconnect.model.GatewayType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.directconnect.model.GatewayType.wrap(value))
    override val ownerAccount: Optional[OwnerAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AssociatedGateway
  ): zio.aws.directconnect.model.AssociatedGateway.ReadOnly = new Wrapper(impl)
}
