package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.directconnect.model.primitives.ConnectionId
import scala.jdk.CollectionConverters._
final case class AssociateMacSecKeyResponse(
    connectionId: Optional[ConnectionId] = Optional.Absent,
    macSecKeys: Optional[Iterable[zio.aws.directconnect.model.MacSecKey]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse = {
    import AssociateMacSecKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse
      .builder()
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(
        macSecKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.macSecKeys)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly =
    zio.aws.directconnect.model.AssociateMacSecKeyResponse.wrap(buildAwsValue())
}
object AssociateMacSecKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.AssociateMacSecKeyResponse =
      zio.aws.directconnect.model.AssociateMacSecKeyResponse(
        connectionId.map(value => value),
        macSecKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionId: Optional[ConnectionId]
    def macSecKeys
        : Optional[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]]
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getMacSecKeys: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.MacSecKey.ReadOnly
    ]] = AwsError.unwrapOptionField("macSecKeys", macSecKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse
  ) extends zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly {
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.directconnect.model.primitives.ConnectionId(value))
    override val macSecKeys
        : Optional[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macSecKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.MacSecKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse
  ): zio.aws.directconnect.model.AssociateMacSecKeyResponse.ReadOnly =
    new Wrapper(impl)
}
