package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  VLAN,
  OwnerAccount,
  ConnectionId,
  ConnectionName,
  Bandwidth
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AllocateHostedConnectionRequest(
    connectionId: ConnectionId,
    ownerAccount: OwnerAccount,
    bandwidth: Bandwidth,
    connectionName: ConnectionName,
    vlan: VLAN,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest = {
    import AllocateHostedConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .ownerAccount(OwnerAccount.unwrap(ownerAccount): java.lang.String)
      .bandwidth(Bandwidth.unwrap(bandwidth): java.lang.String)
      .connectionName(ConnectionName.unwrap(connectionName): java.lang.String)
      .vlan(VLAN.unwrap(vlan): Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.AllocateHostedConnectionRequest.ReadOnly =
    zio.aws.directconnect.model.AllocateHostedConnectionRequest
      .wrap(buildAwsValue())
}
object AllocateHostedConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.AllocateHostedConnectionRequest =
      zio.aws.directconnect.model.AllocateHostedConnectionRequest(
        connectionId,
        ownerAccount,
        bandwidth,
        connectionName,
        vlan,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionId: ConnectionId
    def ownerAccount: OwnerAccount
    def bandwidth: Bandwidth
    def connectionName: ConnectionName
    def vlan: VLAN
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getOwnerAccount: ZIO[Any, Nothing, OwnerAccount] =
      ZIO.succeed(ownerAccount)
    def getBandwidth: ZIO[Any, Nothing, Bandwidth] = ZIO.succeed(bandwidth)
    def getConnectionName: ZIO[Any, Nothing, ConnectionName] =
      ZIO.succeed(connectionName)
    def getVlan: ZIO[Any, Nothing, VLAN] = ZIO.succeed(vlan)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest
  ) extends zio.aws.directconnect.model.AllocateHostedConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.directconnect.model.primitives.ConnectionId(impl.connectionId())
    override val ownerAccount: OwnerAccount =
      zio.aws.directconnect.model.primitives.OwnerAccount(impl.ownerAccount())
    override val bandwidth: Bandwidth =
      zio.aws.directconnect.model.primitives.Bandwidth(impl.bandwidth())
    override val connectionName: ConnectionName =
      zio.aws.directconnect.model.primitives
        .ConnectionName(impl.connectionName())
    override val vlan: VLAN =
      zio.aws.directconnect.model.primitives.VLAN(impl.vlan())
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest
  ): zio.aws.directconnect.model.AllocateHostedConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
