package zio.aws.directconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  VirtualGatewayState,
  VirtualGatewayId
}
import scala.jdk.CollectionConverters._
final case class VirtualGateway(
    virtualGatewayId: Option[VirtualGatewayId] = None,
    virtualGatewayState: Option[VirtualGatewayState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.VirtualGateway = {
    import VirtualGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.VirtualGateway
      .builder()
      .optionallyWith(
        virtualGatewayId.map(value =>
          VirtualGatewayId.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayId)
      .optionallyWith(
        virtualGatewayState.map(value =>
          VirtualGatewayState.unwrap(value): java.lang.String
        )
      )(_.virtualGatewayState)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.VirtualGateway.ReadOnly =
    zio.aws.directconnect.model.VirtualGateway.wrap(buildAwsValue())
}
object VirtualGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.VirtualGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.VirtualGateway =
      zio.aws.directconnect.model.VirtualGateway(
        virtualGatewayId.map(value => value),
        virtualGatewayState.map(value => value)
      )
    def virtualGatewayId: Option[VirtualGatewayId]
    def virtualGatewayState: Option[VirtualGatewayState]
    def getVirtualGatewayId: ZIO[Any, AwsError, VirtualGatewayId] =
      AwsError.unwrapOptionField("virtualGatewayId", virtualGatewayId)
    def getVirtualGatewayState: ZIO[Any, AwsError, VirtualGatewayState] =
      AwsError.unwrapOptionField("virtualGatewayState", virtualGatewayState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.VirtualGateway
  ) extends zio.aws.directconnect.model.VirtualGateway.ReadOnly {
    override val virtualGatewayId: Option[VirtualGatewayId] = scala
      .Option(impl.virtualGatewayId())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualGatewayId(value)
      )
    override val virtualGatewayState: Option[VirtualGatewayState] = scala
      .Option(impl.virtualGatewayState())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualGatewayState(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.VirtualGateway
  ): zio.aws.directconnect.model.VirtualGateway.ReadOnly = new Wrapper(impl)
}
