package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  TestDuration,
  BGPPeerId,
  VirtualInterfaceId
}
import scala.jdk.CollectionConverters._
final case class StartBgpFailoverTestRequest(
    virtualInterfaceId: VirtualInterfaceId,
    bgpPeers: Option[Iterable[BGPPeerId]] = None,
    testDurationInMinutes: Option[TestDuration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest = {
    import StartBgpFailoverTestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest
      .builder()
      .virtualInterfaceId(
        VirtualInterfaceId.unwrap(virtualInterfaceId): java.lang.String
      )
      .optionallyWith(
        bgpPeers.map(value =>
          value.map { item =>
            BGPPeerId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bgpPeers)
      .optionallyWith(
        testDurationInMinutes.map(value => TestDuration.unwrap(value): Integer)
      )(_.testDurationInMinutes)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.StartBgpFailoverTestRequest.ReadOnly =
    zio.aws.directconnect.model.StartBgpFailoverTestRequest
      .wrap(buildAwsValue())
}
object StartBgpFailoverTestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.StartBgpFailoverTestRequest =
      zio.aws.directconnect.model.StartBgpFailoverTestRequest(
        virtualInterfaceId,
        bgpPeers.map(value => value),
        testDurationInMinutes.map(value => value)
      )
    def virtualInterfaceId: VirtualInterfaceId
    def bgpPeers: Option[List[BGPPeerId]]
    def testDurationInMinutes: Option[TestDuration]
    def getVirtualInterfaceId: ZIO[Any, Nothing, VirtualInterfaceId] =
      ZIO.succeed(virtualInterfaceId)
    def getBgpPeers: ZIO[Any, AwsError, List[BGPPeerId]] =
      AwsError.unwrapOptionField("bgpPeers", bgpPeers)
    def getTestDurationInMinutes: ZIO[Any, AwsError, TestDuration] =
      AwsError.unwrapOptionField("testDurationInMinutes", testDurationInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest
  ) extends zio.aws.directconnect.model.StartBgpFailoverTestRequest.ReadOnly {
    override val virtualInterfaceId: VirtualInterfaceId =
      zio.aws.directconnect.model.primitives
        .VirtualInterfaceId(impl.virtualInterfaceId())
    override val bgpPeers: Option[List[BGPPeerId]] = scala
      .Option(impl.bgpPeers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.primitives.BGPPeerId(item)
        }.toList
      )
    override val testDurationInMinutes: Option[TestDuration] = scala
      .Option(impl.testDurationInMinutes())
      .map(value => zio.aws.directconnect.model.primitives.TestDuration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest
  ): zio.aws.directconnect.model.StartBgpFailoverTestRequest.ReadOnly =
    new Wrapper(impl)
}
