package zio.aws.directconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.directconnect.model.primitives.{
  VLAN,
  VirtualInterfaceName,
  MTU,
  BGPAuthKey,
  ASN,
  AmazonAddress,
  CustomerAddress
}
import scala.jdk.CollectionConverters._
final case class NewTransitVirtualInterfaceAllocation(
    virtualInterfaceName: Option[VirtualInterfaceName] = None,
    vlan: Option[VLAN] = None,
    asn: Option[ASN] = None,
    mtu: Option[MTU] = None,
    authKey: Option[BGPAuthKey] = None,
    amazonAddress: Option[AmazonAddress] = None,
    customerAddress: Option[CustomerAddress] = None,
    addressFamily: Option[zio.aws.directconnect.model.AddressFamily] = None,
    tags: Option[Iterable[zio.aws.directconnect.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation = {
    import NewTransitVirtualInterfaceAllocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation
      .builder()
      .optionallyWith(
        virtualInterfaceName.map(value =>
          VirtualInterfaceName.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceName)
      .optionallyWith(vlan.map(value => VLAN.unwrap(value): Integer))(_.vlan)
      .optionallyWith(asn.map(value => ASN.unwrap(value): Integer))(_.asn)
      .optionallyWith(mtu.map(value => MTU.unwrap(value): Integer))(_.mtu)
      .optionallyWith(
        authKey.map(value => BGPAuthKey.unwrap(value): java.lang.String)
      )(_.authKey)
      .optionallyWith(
        amazonAddress.map(value =>
          AmazonAddress.unwrap(value): java.lang.String
        )
      )(_.amazonAddress)
      .optionallyWith(
        customerAddress.map(value =>
          CustomerAddress.unwrap(value): java.lang.String
        )
      )(_.customerAddress)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation.ReadOnly =
    zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation
      .wrap(buildAwsValue())
}
object NewTransitVirtualInterfaceAllocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation =
      zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation(
        virtualInterfaceName.map(value => value),
        vlan.map(value => value),
        asn.map(value => value),
        mtu.map(value => value),
        authKey.map(value => value),
        amazonAddress.map(value => value),
        customerAddress.map(value => value),
        addressFamily.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def virtualInterfaceName: Option[VirtualInterfaceName]
    def vlan: Option[VLAN]
    def asn: Option[ASN]
    def mtu: Option[MTU]
    def authKey: Option[BGPAuthKey]
    def amazonAddress: Option[AmazonAddress]
    def customerAddress: Option[CustomerAddress]
    def addressFamily: Option[zio.aws.directconnect.model.AddressFamily]
    def tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def getVirtualInterfaceName: ZIO[Any, AwsError, VirtualInterfaceName] =
      AwsError.unwrapOptionField("virtualInterfaceName", virtualInterfaceName)
    def getVlan: ZIO[Any, AwsError, VLAN] =
      AwsError.unwrapOptionField("vlan", vlan)
    def getAsn: ZIO[Any, AwsError, ASN] = AwsError.unwrapOptionField("asn", asn)
    def getMtu: ZIO[Any, AwsError, MTU] = AwsError.unwrapOptionField("mtu", mtu)
    def getAuthKey: ZIO[Any, AwsError, BGPAuthKey] =
      AwsError.unwrapOptionField("authKey", authKey)
    def getAmazonAddress: ZIO[Any, AwsError, AmazonAddress] =
      AwsError.unwrapOptionField("amazonAddress", amazonAddress)
    def getCustomerAddress: ZIO[Any, AwsError, CustomerAddress] =
      AwsError.unwrapOptionField("customerAddress", customerAddress)
    def getAddressFamily
        : ZIO[Any, AwsError, zio.aws.directconnect.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation
  ) extends zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation.ReadOnly {
    override val virtualInterfaceName: Option[VirtualInterfaceName] = scala
      .Option(impl.virtualInterfaceName())
      .map(value =>
        zio.aws.directconnect.model.primitives.VirtualInterfaceName(value)
      )
    override val vlan: Option[VLAN] = scala
      .Option(impl.vlan())
      .map(value => zio.aws.directconnect.model.primitives.VLAN(value))
    override val asn: Option[ASN] = scala
      .Option(impl.asn())
      .map(value => zio.aws.directconnect.model.primitives.ASN(value))
    override val mtu: Option[MTU] = scala
      .Option(impl.mtu())
      .map(value => zio.aws.directconnect.model.primitives.MTU(value))
    override val authKey: Option[BGPAuthKey] = scala
      .Option(impl.authKey())
      .map(value => zio.aws.directconnect.model.primitives.BGPAuthKey(value))
    override val amazonAddress: Option[AmazonAddress] = scala
      .Option(impl.amazonAddress())
      .map(value => zio.aws.directconnect.model.primitives.AmazonAddress(value))
    override val customerAddress: Option[CustomerAddress] = scala
      .Option(impl.customerAddress())
      .map(value =>
        zio.aws.directconnect.model.primitives.CustomerAddress(value)
      )
    override val addressFamily
        : Option[zio.aws.directconnect.model.AddressFamily] = scala
      .Option(impl.addressFamily())
      .map(value => zio.aws.directconnect.model.AddressFamily.wrap(value))
    override val tags: Option[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation
  ): zio.aws.directconnect.model.NewTransitVirtualInterfaceAllocation.ReadOnly =
    new Wrapper(impl)
}
